---
title: Threaded replies now possible in Email Workers · Changelog
description: You can now use Email Workers to send multiple replies to the same
  email thread.
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/changelog/2025-03-12-reply-limits/
  md: https://developers.cloudflare.com/changelog/2025-03-12-reply-limits/index.md
---

# Changelog

New updates and improvements at Cloudflare.

[Subscribe to RSS](https://developers.cloudflare.com/changelog/rss/index.xml)\
[View all RSS feeds](https://developers.cloudflare.com/fundamentals/new-features/available-rss-feeds/)

![hero image](https://developers.cloudflare.com/_astro/hero.CVYJHPAd_ZEA2nF.svg)

[← Back to all posts](https://developers.cloudflare.com/changelog/)

## Threaded replies now possible in Email Workers

Mar 12, 2025

[Email Routing](https://developers.cloudflare.com/email-routing/)

We’re removing some of the restrictions in Email Routing so that AI Agents and task automation can better handle email workflows, including how Workers can [reply](https://developers.cloudflare.com/email-routing/email-workers/reply-email-workers/) to incoming emails.

It's now possible to keep a threaded email conversation with an [Email Worker](https://developers.cloudflare.com/email-routing/email-workers/) script as long as:

* The incoming email has to have valid [DMARC](https://www.cloudflare.com/learning/dns/dns-records/dns-dmarc-record/).
* The email can only be replied to once in the same `EmailMessage` event.
* The recipient in the reply must match the incoming sender.
* The outgoing sender domain must match the same domain that received the email.
* Every time an email passes through Email Routing or another MTA, an entry is added to the `References` list. We stop accepting replies to emails with more than 100 `References` entries to prevent abuse or accidental loops.

Here's an example of a Worker responding to Emails using a Workers AI model:

```ts
import PostalMime from "postal-mime";
import { createMimeMessage } from "mimetext";
import { EmailMessage } from "cloudflare:email";


export default {
  async email(message, env, ctx) {
    const email = await PostalMime.parse(message.raw);
    const res = await env.AI.run("@cf/meta/llama-2-7b-chat-fp16", {
      messages: [
        {
          role: "user",
          content: email.text ?? "",
        },
      ],
    });


    // message-id is generated by mimetext
    const response = createMimeMessage();
    response.setHeader("In-Reply-To", message.headers.get("Message-ID")!);
    response.setSender("agent@example.com");
    response.setRecipient(message.from);
    response.setSubject("Llama response");
    response.addMessage({
      contentType: "text/plain",
      data:
        res instanceof ReadableStream
          ? await new Response(res).text()
          : res.response!,
    });


    const replyMessage = new EmailMessage(
      "<email>",
      message.from,
      response.asRaw(),
    );
    await message.reply(replyMessage);
  },
} satisfies ExportedHandler<Env>;
```

See [Reply to emails from Workers](https://developers.cloudflare.com/email-routing/email-workers/reply-email-workers/) for more information.
