---
title: Response Buffering · Cloudflare Network settings docs
description: If your domain sends many small packets, it may be faster to buffer
  the file and deliver the full payload all at once (instead of streaming it).
lastUpdated: 2025-06-11T17:18:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/network/response-buffering/
  md: https://developers.cloudflare.com/network/response-buffering/index.md
---

If your domain sends many small packets, it may be faster to buffer the file and deliver the full payload all at once (instead of streaming it).

## Availability

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | No | No | No | Yes |

## How it works

By default, Cloudflare **streams** traffic data, meaning that each packet is sent as it becomes available. This can improve the delivery of large files. However, this streaming behavior only applies to dynamic traffic; cacheable traffic (that is, **any** status noted in [Cloudflare cache responses](https://developers.cloudflare.com/cache/concepts/cache-responses/) with the exception of **DYNAMIC**) is buffered and this behavior cannot be changed.

If your domain sends many small packets, however, it might be faster to **buffer** the file. This approach waits to send the full file until all packets are ready, preventing a client browser from having to re-assemble packets.

## Enable Response Buffering

* Dashboard

  To enable **Response Buffering** in the dashboard:

  1. Log in to your [Cloudflare account](https://dash.cloudflare.com) and go to a specific domain.
  2. Go to **Network**.
  3. For **Response Buffering**, switch the toggle to **On**.

* API

  To enable **Response Buffering** with the API, send a [`PATCH`](https://developers.cloudflare.com/api/resources/zones/subresources/settings/methods/edit/) request with `response_buffering` as the setting name in the URI path, and the `value` parameter set to `"on"`.
