---
title: Inline badge · Cloudflare Style Guide
description: To adopt this styling in a React component, apply the sl-badge
  class to a span element.
lastUpdated: 2025-03-06T20:33:22.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/inline-badge/
  md: https://developers.cloudflare.com/style-guide/components/inline-badge/index.md
---

Recommendation: Avoid inline badges

Our current recommendation is to avoid inline badges, since they may hurt readability.

Guidelines:

* Mention beta/alpha/early access in the feature's main documentation page (use the [`<Badge>`](https://developers.cloudflare.com/style-guide/components/badges/) component for this purpose).
* If an additional reference is needed in the middle of the text, use "(beta)", with no special formatting, after the feature name.
* For instructions related to the feature (such as instructions on turning the feature on or off), you may mention again it's in beta, and also include "(beta)" in the side nav.

## Component

To adopt this styling in a React component, apply the `sl-badge` class to a `span` element.

## Inputs

Either `preset` or `text` and `variant` must be specified.

### Presets

* `alpha`

  * **Text**: `Alpha`
  * **Variant** `success`

* `beta`

  * **Text**: `Beta`
  * **Variant** `caution`

* `deprecated`

  * **Text**: `Deprecated`
  * **Variant** `danger`

* `early-access`

  * **Text**: `Early Access`
  * **Variant** `note`

* `legacy`

  * **Text**: `Legacy`
  * **Variant** `danger`

### Text

Any string.

### Variant

* `note`

  * **Color**: Blue

* `tip`

  * **Color**: Purple

* `danger`

  * **Color**: Red

* `caution`

  * **Color**: Orange

* `success`

  * **Color**: Green
